﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FUTEK_USB_DLL;

namespace LCDExample
{

    public partial class FormMain : Form
    {

        public FUTEK_USB_DLL.USB_DLL oFutekUSBDLL;

        public string SerialNumber;
        public string DeviceHandle;
        public string Temp;

        public Boolean OpenedConnection;
        private char delimiter;

        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            oFutekUSBDLL = new FUTEK_USB_DLL.USB_DLL();
            
            Text = "Microsoft Visual C# Example Using FUTEK USB DLL " +
                System.Reflection.Assembly.GetAssembly(typeof(FUTEK_USB_DLL.USB_DLL)).GetName().Version.ToString();

            SerialNumber = "";
            TextBoxSerialNumber.Text = "Enter Here";

            DeviceHandle = "0";
            delimiter = ' ';
            OpenedConnection = false;
        }

        private void FormMain_Disposed(object sender, EventArgs e)
        {
            TimerReading.Enabled = false;

            if (OpenedConnection == true) { }
            else
            { return; }

            oFutekUSBDLL.Close_Device_Connection(DeviceHandle);
            if (oFutekUSBDLL.DeviceStatus == "0") { }
            else
            {
                MessageBox.Show("Device Error " + oFutekUSBDLL.DeviceStatus);
                return;
            }

            OpenedConnection = false;
        }


        public static System.Boolean IsNumeric(System.Object expression)
        {

            if (expression == null || expression is DateTime)
                return false;

            if (expression is Int16 || expression is Int32 || expression is Int64 || expression is Decimal || expression is Single || expression is Double || expression is Boolean)
                return true;

            try
            {
                if (expression is string)
                    Double.Parse(expression as string);
                else
                    Double.Parse(expression.ToString());
                return true;
            }
            catch { } // just dismiss errors but return false
            return false;

        }

        private void ButtonStart_Click(object sender, EventArgs e)
        {

            SerialNumber = TextBoxSerialNumber.Text;

            if (OpenedConnection == false) { }
            else
            { return; }

            oFutekUSBDLL.Open_Device_Connection(SerialNumber);

            if (oFutekUSBDLL.DeviceStatus == "0") { }
            else
            {
                MessageBox.Show("Device Error " + oFutekUSBDLL.DeviceStatus);
                return;
            }

            DeviceHandle = oFutekUSBDLL.DeviceHandle;

            OpenedConnection = true;

            TimerReading.Interval = 500;
            TimerReading.Enabled = true;

        }

        private void ButtonStop_Click(object sender, EventArgs e)
        {

            TimerReading.Enabled = false;

            if (OpenedConnection == true) { }
            else
            { return; }

            oFutekUSBDLL.Close_Device_Connection(DeviceHandle);
            if (oFutekUSBDLL.DeviceStatus == "0") { }
            else
            {
                MessageBox.Show("Device Error " + oFutekUSBDLL.DeviceStatus);
                return;
            }

            OpenedConnection = false;

        }

        private void TimerReading_Tick(object sender, EventArgs e)
        {
            oFutekUSBDLL.Get_Display_Page(DeviceHandle);
            Temp = oFutekUSBDLL.LCDLine2;
            string[] words = Temp.Split(delimiter);

            if (!IsNumeric(words[0]))
            {
                if (words[0] == "OVERFLOW")
                {
                    TextBoxCalculatedReading.Text = "OVERFLOW";
                    TextBoxUnits.Text = words[words.Count() - 1];
                }
                else
                {
                    TextBoxCalculatedReading.Text = "Error";
                    TextBoxUnits.Text = "-";
                }
            }
            else
            {
                TextBoxCalculatedReading.Text = words[0];
                TextBoxUnits.Text = words[words.Count() - 1];
            }
        }
    }
}
